// 2003/03/18 SvTrackerPage.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.IO;

namespace NTF.HXD.GUI.TabPage
{
	/// <summary>
	/// gbJ[ݒŎgpRg[
	/// </summary>
	public class SvTrackerPage : System.Windows.Forms.UserControl , IConfigTabPage
	{

		#region Rg[

		private System.Windows.Forms.Label label25;
		private System.Windows.Forms.Label label24;
		private System.Windows.Forms.Label label23;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.ComponentModel.IContainer components;
		private CtrlLib.NumEdit nUsersBox;
		private System.Windows.Forms.TextBox descriptionBox;
		private System.Windows.Forms.ListView trackerListView;
		private System.Windows.Forms.CheckBox enableTrackerCheck;
		private System.Windows.Forms.ToolBarButton tbAdd;
		private System.Windows.Forms.ToolBar trackerBar;
		private System.Windows.Forms.ToolBarButton tbEdit;
		private System.Windows.Forms.ToolBarButton tbRemove;
		private System.Windows.Forms.ImageList imageList;

		#endregion


		Appli appli;

		/// <summary>
		/// gbJ[XgҏWp̃fQ[g
		/// </summary>
		public delegate void SetTrackerServerItem(string address,string password);
		SetTrackerServerItem addTrackerItem;
		SetTrackerServerItem editTrackerItem;


		public SvTrackerPage(Appli appli)
		{
			InitializeComponent();

			this.appli = appli;

			LoadConfig();

			addTrackerItem	= new SetTrackerServerItem( AddTrackerItem );
			editTrackerItem = new SetTrackerServerItem( EditTrackerItem );
			this.Dock = DockStyle.Fill;
		}


		/// <summary>
		/// ݒǂݍŔf܂B
		/// </summary>
		public void LoadConfig()
		{
			this.enableTrackerCheck.Checked = appli.AppConfig.EnableTrakcer;
			this.nUsersBox.Text	= appli.ServerConfig.TrackerConfig.Nusers;
			this.descriptionBox.Text = appli.ServerConfig.TrackerConfig.Description;

			this.LoadTrackerList();

			changed = false;
		}


		/// <summary>
		/// ݒvpeBɊi[܂B
		/// </summary>
		public void SaveConfig()
		{
			appli.AppConfig.EnableTrakcer = this.enableTrackerCheck.Checked;
			appli.ServerConfig.TrackerConfig.Nusers	= this.nUsersBox.Text;
			appli.ServerConfig.TrackerConfig.Description = this.descriptionBox.Text.Replace("\r\n" , "");

			if( this.enableTrackerCheck.Checked )
			{
				SaveTrackerConfig();
			}

			SaveTrackerList();
		}


		bool changed = false;
		/// <summary>
		/// ݒ肪ύXAݒ𔽉fɂ͍ċNKvȂƂtrueԂB
		/// </summary>
		public bool Changed
		{
			get{return changed;}
			set{changed = value;}
		}

		private void PropertyChanged(object sender, System.EventArgs e)
		{
			this.changed = true;
		}


		#region ToolBar

		private void trackerBar_ButtonClick(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e)
		{		
			switch(trackerBar.Buttons.IndexOf(e.Button))
			{
				case 0:
					EditTrackerDialog dialog = new EditTrackerDialog( this.addTrackerItem );
					dialog.ShowDialog();
					break;

				case 1:
					trackerListView_DoubleClick( this , EventArgs.Empty );
					break;

				case 2:
					if( this.trackerListView.SelectedItems.Count > 0 )
					{
						this.trackerListView.Items.Remove( this.trackerListView.SelectedItems[0] );
					}
					break;
			}
		}

		#endregion


		#region gbJ[Xg֌W

		private void AddTrackerItem(string address,string password)
		{
			ListViewItem item = new ListViewItem( new string[]{
																													address ,
																													password,}
				);
			this.trackerListView.Items.Add( item );
		}

		private void EditTrackerItem(string address,string password)
		{
			if( this.trackerListView.SelectedItems.Count > 0 )
			{
				this.trackerListView.SelectedItems[0].Text = address;
				this.trackerListView.SelectedItems[0].SubItems[1].Text = password;
			}
		}


		private void trackerListView_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if( this.trackerListView.SelectedItems.Count > 0 )
			{
				this.tbEdit.Enabled = true;
				this.tbRemove.Enabled = true;
			}
			else
			{
				this.tbEdit.Enabled = false;
				this.tbRemove.Enabled = false;
			}
		}

		private void trackerListView_DoubleClick(object sender, System.EventArgs e)
		{
			if( this.trackerListView.SelectedItems.Count > 0 )
			{
				EditTrackerDialog dialog = new EditTrackerDialog(this.trackerListView.SelectedItems[0] 
					,this.editTrackerItem
					);
				dialog.ShowDialog();
			}
		}

		#endregion


		#region gbJ[Xg̕ۑAǂݏo

		private void SaveTrackerList()
		{
			ArrayList listArray = new ArrayList( this.trackerListView.Items );
			try
			{
				IFormatter formatter = new BinaryFormatter();
				using(Stream stream = new FileStream( (Application.StartupPath + "\\Data\\TrackerList.bin" ), FileMode.Create ,FileAccess.Write ))
				{
					formatter.Serialize(stream, listArray);
				}
			}
			catch
			{
				MessageBox.Show ( "gbJ[T[o[̐ݒۑɎs܂B" 
					, "G[" ,
					MessageBoxButtons.OK, MessageBoxIcon.Error);

			}
		}


		private void LoadTrackerList()
		{
			ArrayList listArray = new ArrayList();
			try
			{
				IFormatter formatter = new BinaryFormatter();
				using(Stream stream = new FileStream(Application.StartupPath + "\\Data\\TrackerList.bin", FileMode.Open, FileAccess.Read, FileShare.Read))
				{
					listArray = (ArrayList)formatter.Deserialize(stream);
				}
			}
			catch(System.Exception err)
			{
				System.Diagnostics.Debug.WriteLine(err);
			}
			
			this.trackerListView.BeginUpdate();
			for( int i = 0 ; i < listArray.Count ; i++ )
			{
				((ListViewItem)listArray[i]).ImageIndex = 0;

				this.trackerListView.Items.Add( (ListViewItem)listArray[i] );
			}
			this.trackerListView.EndUpdate();
		}

		private void SaveTrackerConfig()
		{
			if( this.trackerListView.Items.Count < 1 )
			{
				return;
			}

			string[] trackerConfig = new string[ this.trackerListView.Items.Count ];
			ListViewItem item = null;

			for(int i = 0 ; i < trackerConfig.Length  ; i++ )
			{
				item = this.trackerListView.Items[i];

				if( item.SubItems[1].Text.Equals( string.Empty ) )
				{
					trackerConfig[i] = item.Text;
					continue;
				}
				trackerConfig[i] = "0x7a69" + ":" + 
					item.SubItems[1].Text + "@" +
					item.Text;
			}

			if( trackerConfig == null )
			{
				return;
			}

			appli.ServerConfig.TrackerConfig.Trackers = new ArrayList(trackerConfig);
		}

		#endregion


		#region Dispose
		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion


		#region Component Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(SvTrackerPage));
			this.label25 = new System.Windows.Forms.Label();
			this.label24 = new System.Windows.Forms.Label();
			this.nUsersBox = new CtrlLib.NumEdit();
			this.label23 = new System.Windows.Forms.Label();
			this.descriptionBox = new System.Windows.Forms.TextBox();
			this.trackerListView = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.trackerBar = new System.Windows.Forms.ToolBar();
			this.tbAdd = new System.Windows.Forms.ToolBarButton();
			this.tbEdit = new System.Windows.Forms.ToolBarButton();
			this.tbRemove = new System.Windows.Forms.ToolBarButton();
			this.imageList = new System.Windows.Forms.ImageList(this.components);
			this.enableTrackerCheck = new System.Windows.Forms.CheckBox();
			this.SuspendLayout();
			// 
			// label25
			// 
			this.label25.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label25.Location = new System.Drawing.Point(237, 33);
			this.label25.Name = "label25";
			this.label25.Size = new System.Drawing.Size(115, 17);
			this.label25.TabIndex = 24;
			this.label25.Text = "li|PŎۂ̐)";
			// 
			// label24
			// 
			this.label24.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label24.Location = new System.Drawing.Point(9, 32);
			this.label24.Name = "label24";
			this.label24.Size = new System.Drawing.Size(156, 17);
			this.label24.TabIndex = 23;
			this.label24.Text = "gbJ[ɑM郆[U[ : ";
			// 
			// nUsersBox
			// 
			this.nUsersBox.InputType = CtrlLib.NumEdit.NumEditType.Integer;
			this.nUsersBox.Location = new System.Drawing.Point(172, 30);
			this.nUsersBox.Name = "nUsersBox";
			this.nUsersBox.Size = new System.Drawing.Size(57, 19);
			this.nUsersBox.TabIndex = 22;
			this.nUsersBox.Text = "-1";
			this.nUsersBox.TextChanged += new System.EventHandler(this.PropertyChanged);
			// 
			// label23
			// 
			this.label23.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label23.Location = new System.Drawing.Point(2, 62);
			this.label23.Name = "label23";
			this.label23.Size = new System.Drawing.Size(113, 13);
			this.label23.TabIndex = 21;
			this.label23.Text = "T[o[̐ : ";
			// 
			// descriptionBox
			// 
			this.descriptionBox.AcceptsReturn = true;
			this.descriptionBox.AcceptsTab = true;
			this.descriptionBox.Location = new System.Drawing.Point(-1, 77);
			this.descriptionBox.MaxLength = 0;
			this.descriptionBox.Multiline = true;
			this.descriptionBox.Name = "descriptionBox";
			this.descriptionBox.ScrollBars = System.Windows.Forms.ScrollBars.Both;
			this.descriptionBox.Size = new System.Drawing.Size(582, 60);
			this.descriptionBox.TabIndex = 20;
			this.descriptionBox.Text = "";
			this.descriptionBox.WordWrap = false;
			this.descriptionBox.TextChanged += new System.EventHandler(this.PropertyChanged);
			// 
			// trackerListView
			// 
			this.trackerListView.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																																											this.columnHeader1,
																																											this.columnHeader2});
			this.trackerListView.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.trackerListView.FullRowSelect = true;
			this.trackerListView.GridLines = true;
			this.trackerListView.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
			this.trackerListView.HoverSelection = true;
			this.trackerListView.Location = new System.Drawing.Point(0, 161);
			this.trackerListView.MultiSelect = false;
			this.trackerListView.Name = "trackerListView";
			this.trackerListView.Size = new System.Drawing.Size(584, 97);
			this.trackerListView.TabIndex = 19;
			this.trackerListView.View = System.Windows.Forms.View.Details;
			this.trackerListView.DoubleClick += new System.EventHandler(this.trackerListView_DoubleClick);
			this.trackerListView.SelectedIndexChanged += new System.EventHandler(this.trackerListView_SelectedIndexChanged);
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "AhX";
			this.columnHeader1.Width = 300;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "pX[h";
			this.columnHeader2.Width = 240;
			// 
			// trackerBar
			// 
			this.trackerBar.Appearance = System.Windows.Forms.ToolBarAppearance.Flat;
			this.trackerBar.Buttons.AddRange(new System.Windows.Forms.ToolBarButton[] {
																																									this.tbAdd,
																																									this.tbEdit,
																																									this.tbRemove});
			this.trackerBar.Dock = System.Windows.Forms.DockStyle.None;
			this.trackerBar.DropDownArrows = true;
			this.trackerBar.ImageList = this.imageList;
			this.trackerBar.Location = new System.Drawing.Point(-1, 136);
			this.trackerBar.Name = "trackerBar";
			this.trackerBar.ShowToolTips = true;
			this.trackerBar.Size = new System.Drawing.Size(587, 25);
			this.trackerBar.TabIndex = 18;
			this.trackerBar.TextAlign = System.Windows.Forms.ToolBarTextAlign.Right;
			this.trackerBar.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler(this.trackerBar_ButtonClick);
			// 
			// tbAdd
			// 
			this.tbAdd.ImageIndex = 0;
			this.tbAdd.Text = "ǉ";
			// 
			// tbEdit
			// 
			this.tbEdit.Enabled = false;
			this.tbEdit.ImageIndex = 1;
			this.tbEdit.Text = "ҏW";
			// 
			// tbRemove
			// 
			this.tbRemove.Enabled = false;
			this.tbRemove.ImageIndex = 2;
			this.tbRemove.Text = "폜";
			// 
			// imageList
			// 
			this.imageList.ColorDepth = System.Windows.Forms.ColorDepth.Depth8Bit;
			this.imageList.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList.ImageStream")));
			this.imageList.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// enableTrackerCheck
			// 
			this.enableTrackerCheck.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.enableTrackerCheck.Location = new System.Drawing.Point(9, 3);
			this.enableTrackerCheck.Name = "enableTrackerCheck";
			this.enableTrackerCheck.Size = new System.Drawing.Size(134, 24);
			this.enableTrackerCheck.TabIndex = 17;
			this.enableTrackerCheck.Text = "gbJ[ɓo^B";
			this.enableTrackerCheck.CheckedChanged += new System.EventHandler(this.PropertyChanged);
			// 
			// SvTrackerPage
			// 
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																																	this.label25,
																																	this.label24,
																																	this.nUsersBox,
																																	this.label23,
																																	this.descriptionBox,
																																	this.trackerListView,
																																	this.trackerBar,
																																	this.enableTrackerCheck});
			this.Name = "SvTrackerPage";
			this.Size = new System.Drawing.Size(584, 258);
			this.ResumeLayout(false);

		}
		#endregion


	}
}
